#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N;
    cin >> N;

    vector<int> A(N), B(N);
    for (int i = 0; i < N; ++i) cin >> A[i];
    for (int i = 0; i < N; ++i) cin >> B[i];

    vector<int> Xor(N + 1, 0);
    for (int i = 1; i <= N; ++i) {
        Xor[i] = Xor[i - 1] ^ A[i - 1];
    }

    int maxVal = 0;

    for (int L = 0; L < N; ++L) {
        int andVal = B[L]; 
        for (int R = L; R < N; ++R) {
            andVal &= B[R];
            if (andVal == 0) break; 

            int xorVal = Xor[R + 1] ^ Xor[L];
            maxVal = max(maxVal, xorVal * andVal);
        }
    }

    cout << maxVal << endl;

    return 0;
}